<?xml version="1.0"?>
<xsl:stylesheet 
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      version="1.0">
   <xsl:template match="/root">
       <html>
         <head>
		 <META http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
         <style type="text/css">
           body {  font-family: Verdana, Arial, Helvetica, sans-serif}
           h1 {  font-size: 12pt; font-weight: bold; font-style: normal}
           th {  font-size: 8pt; font-weight: bold; text-decoration: underline}
           td {  font-size: 8pt; font-family: Verdana, Arial, Helvetica, sans-serif }
         </style>
           <title><xsl:value-of select="/root/header/@title"/></title>
         </head>
         <body>
			<h1><xsl:value-of select="/root/header/@title"/></h1>
            <table border="1" cellSpacing="0" cellPadding="4">
              <xsl:text>&#13;</xsl:text>
              <tr>
				<th><xsl:value-of select="/root/header/abbr/@name"/></th>
                <th><xsl:value-of select="/root/header/severity/@name"/></th>
                <th><xsl:value-of select="/root/header/text/@name"/></th>
                <th><xsl:value-of select="/root/header/resource/@name"/></th>
                <th><xsl:value-of select="/root/header/file/@name"/></th>
                <th><xsl:value-of select="/root/header/line/@name"/></th>
              </tr>
              <xsl:apply-templates select="/root/audit"/>
              <xsl:text>&#13;</xsl:text>
            </table>
         </body>
       </html>
   </xsl:template>
   <xsl:template match="audit">
       <xsl:text>&#13;</xsl:text>
       <tr>
         <td><xsl:value-of select="@id"/></td>
         <td>
         <xsl:choose>
           <xsl:when test="@severity = 3"><font color="red"><xsl:value-of select="/root/severity/id3/@name"/></font></xsl:when>
           <xsl:when test="@severity = 2"><font color="red"><xsl:value-of select="/root/severity/id2/@name"/></font></xsl:when>
           <xsl:when test="@severity = 1"><xsl:value-of select="/root/severity/id1/@name"/></xsl:when>
           <xsl:when test="@severity = 0"><font color="blue"><xsl:value-of select="/root/severity/id0/@name"/></font></xsl:when>
         </xsl:choose>
         </td>
         <td><xsl:value-of select="@message"/></td>
         <td><xsl:value-of select="@resource"/></td>
         <td>
            <xsl:if test="string-length(@url)!=0">
              <xsl:value-of select="/root/project/@path"/><xsl:value-of select="@url"/>
            </xsl:if>
            <xsl:if test="string-length(@url)=0">
              <xsl:text>&#160;</xsl:text>
            </xsl:if>
         </td>
         <td align="right"><xsl:value-of select="@line"/></td>
       </tr>
       <xsl:apply-templates select="audit"/>
   </xsl:template>
   <xsl:template match="audit/audit">
       <xsl:text>&#13;</xsl:text>
       <tr>
         <td>&#160;</td>
         <td>
         <xsl:choose>
           <xsl:when test="@severity = 3"><font color="red"><xsl:value-of select="/root/severity/id3/@name"/></font></xsl:when>
           <xsl:when test="@severity = 2"><font color="red"><xsl:value-of select="/root/severity/id2/@name"/></font></xsl:when>
           <xsl:when test="@severity = 1"><xsl:value-of select="/root/severity/id1/@name"/></xsl:when>
           <xsl:when test="@severity = 0"><font color="blue"><xsl:value-of select="/root/severity/id0/@name"/></font></xsl:when>
         </xsl:choose>
         </td>
         <td><xsl:value-of select="@message"/></td>
         <td><xsl:value-of select="@resource"/></td>
         <td><xsl:value-of select="/root/project/@path"/><xsl:value-of select="@url"/></td>
         <td align="right"><xsl:value-of select="@line"/></td>
       </tr>
   </xsl:template>
</xsl:stylesheet>
